SELECT s.name AS TABLE_SCHEMA, o.name AS TABLE_NAME,
       i.name as INDEX_NAME,
       his.total_bucket_count,
       his.empty_bucket_count,
       floor((cast(empty_bucket_count as float) / total_bucket_count) * 100) AS empty_bucket_percent,
       his.avg_chain_length,
       his.max_chain_length
FROM   sys.dm_db_xtp_hash_index_stats AS his
       INNER JOIN sys.indexes AS i
             ON his.object_id = i.object_id
                AND his.index_id = i.index_id
       INNER JOIN sys.objects AS o
             ON his.object_id = o.object_id
       INNER JOIN sys.schemas AS s
             ON o.schema_id = s.schema_id;